program TestArray;
{$APPTYPE CONSOLE}
{ Test program for DynamicArray unit. }

uses
  DynamicArray;

type
  TFloatArray = class(TDynamicArray)
  public
    constructor Create; override;                   // Descendants must override Create().
    function GetFloat(i: Integer): Single;          // Interfaces GetItem().
    procedure SetFloat(i: Integer; value: Single);  // Iterfaces SetItem().
    { The Items property is default, so you can read and write myArray[index]
      instead of using GetFloat() and SetFloat(). Just like a plain array... }
    property Items[i: Integer]: Single read GetFloat write SetFloat; default;
  end;

constructor TFloatArray.Create;
begin

  inherited Create;
  // Override the default item size of 1 byte. Any descendant class should do this!
  FItemSize := SizeOf(Single);

end;

function TFloatArray.GetFloat(i: Integer): Single;
begin

  { Just call GetItem() to retrieve the result. This method is here to make sure
    the correct data type is returned. }
  GetItem(i, Result);

end;

procedure TFloatArray.SetFloat(i: Integer; value: Single);
begin

  // Interface to SetItem(). Again, this avoids incorrect parameter types.
  SetItem(i, value);

end;

var
  a: TFloatArray;
  i: Byte;
  res: array [0..10] of Single;
begin

  // Test the TFloatArray class:
  a := TFloatArray.Create;        // Create a dynamic array.

  for i := 0 to 10 do a[i] := i;  // Fill up the dynamic array.
  for i := 0 to 10 do
  begin
    res[i] := a[i];               // Copy elements from a to res.
    WriteLn(res[i]);              // Write to screen to verify correctness.
  end;
  ReadLn;                         // Don't close window immediately.
  a.Free;                         // Dispose of array.

end.
